#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../common/cancel_appointment'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'
require_relative '../../pages/landing_notifications'

describe '[Story# VAR-7749: Direct Scheduling Confirmation Page:  Update to show facility location]
          [Story# VAR-10186: VAR & Utility Integration - Direct Scheduling - New Appointment Form - Location selection]' do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback = Feedback.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    TITLE = "Appointments/Requests"

    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    @twentyoneDaysLater = getDateNthDaysFromNow(21, "%m/%d/%Y")
    @fourteenDaysLater = getDateNthDaysFromNow(14, "%m/%d/%Y")
    @nintyDaysLater = getDateNthDaysFromNow(90, "%m/%d/%Y")
    #cancel appointment
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@fourteenDaysLater} 11:00:00")
    @cancel_appointment.update_appointment_obj("clinicId", "64")
    @cancel_appointment.update_appointment_obj("clinicName", "AUDIOLOGY")
    @cancel_appointment.cancel_appointment()
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@twentyoneDaysLater} 11:00:00")
    @cancel_appointment.cancel_appointment()

    @@timeSlot = "11:00"
    @@timeSlot2 = "11:00"
    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    deletePatientData("1113138327")
    @clinic_friendly_name ="Audiology Clinic"
    @location = "BOSTON HCS VAMC"
    ## The clinic name is diff in cdw v/s mdws but in real world its same per Chris. We may need to update this test once clinic name
    # for details, list and appointment form is being pulled from same place
    @clinic = "BO RHEUM DUBREUIL"
    @friendly_name_boston = "Facility Friendly Text (BOSTON, MA)"
    @friendly_name_boston_details = "Facility Friendly Text"
    @friendly_name_brockton = "Facility Friendly Brockton (BROCKTON, MA)"
    @friendly_name = "Facility Friendly Text"
    @common.loginEndsOnHome(pw_redacted)
    @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
    @common.selectAddAppointmentButton("VA")
  end

  after(:all) do
    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@@setDate} 11:00:00")
    @cancel_appointment.update_appointment_obj("clinicId", "64")
    @cancel_appointment.update_appointment_obj("clinicName", "AUDIOLOGY")
    @cancel_appointment.cancel_appointment()
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@@setDate2} 11:00:00")
    @cancel_appointment.cancel_appointment()
    @driver.close
  end

  context 'AC#VAR-10127|TC#VAR-10128: Direct Scheduling Confirmation Page:  Update to show facility location default name' do

    it 'Verify newly created appointment status' do
      @new_appointment.createAppointment('audiology', '523', '64', 'test', @fourteenDaysLater, @@timeSlot, 'testAutomation@testAutomationxyz.com')
      @@setDate = NewAppointmentRequest.bookedDate
      expect(@detail.isConfirmationDisplayed?).to eq(true)
      expect(@detail.appointment_status_group_element.text).to eq("Status:  Scheduled")
    end

    it "Verify newly created appointment facility name in details" do
      @@selectedDay = getDayofWeek(@@setDate)
      @@timeSlot = @@timeSlot.gsub!(':', '')
      expected_text = [\
          "Date and Time:" + " #{@@selectedDay}," + " #{@@setDate}",
          "Date:" + " #{@@selectedDay},"+ " #{@@setDate}",
          @@timeSlot,
          "Time: #{@@timeSlot.gsub("", " ")}",
          "Add to Calendar",
          "Details: " + "#{@location}",
          "#{@clinic_friendly_name}",
          "Also called: #{@clinic}",
          "Please arrive 30 minutes before your scheduled time unless otherwise directed. VA Facility Locator",
          "Cancel Appointment",
          "Reason for Appointment: test"
      ]
      actual_text = @detail.appointment_details_group_element.text.split("\n")
      actual_text = actual_text.reject { |c| c.empty? }
      expected_text.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i].gsub(/\s+/, '')).to eq(expectedScreenRow.gsub(/\s+/, ''))
      end

    end


  end

  context 'AC#VAR-10127|TC#VAR-10128: Direct Scheduling Confirmation Page:  Update to show facility location friendly name' do


    it 'Create appointment where friendly name is set for a facility ' do
      button_element = @driver.button(:id => 'back-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notification_detail_new_appt_element.wait_until_present(TIME_OUT_LIMIT)
      restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name_boston.json", @db)
      @common.selectAddAppointmentButton("VA")
      @new_appointment.createAppointment(AUDIOLOGY, '523', '64', 'test', @twentyoneDaysLater, @@timeSlot2, 'testAutomation@testAutomationxyz.com')
      @@setDate2 = NewAppointmentRequest.bookedDate
      expect(@detail.isConfirmationDisplayed?).to eq(true)
      expect(@detail.appointment_status_group_element.text).to eq("Status:  Scheduled")
    end

    it 'Verify newly created appointment details and facility friendly name in details' do

      @@selectedDay = getDayofWeek(@@setDate2)
      @@timeSlot2 = @@timeSlot2.gsub!(':', '')
      expected_text = [\
          "Date and Time:" + " #{@@selectedDay}," + " #{@@setDate2}",
          "Date:" + " #{@@selectedDay},"+ " #{@@setDate2}",
          @@timeSlot2,
          "Time: #{@@timeSlot2.gsub("", " ")}",
          "Add to Calendar",
          "Details: " + "#{@friendly_name_boston_details}",
          "#{@clinic_friendly_name}",
          "Also called: #{@clinic}",
          "Please arrive 30 minutes before your scheduled time unless otherwise directed. VA Facility Locator",
          "Cancel Appointment",
          "Reason for Appointment: test"
      ]
      actual_text = @detail.appointment_details_group_element.text.split("\n")
      actual_text = actual_text.reject { |c| c.empty? }
      expected_text.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i].gsub(/\s+/, '')).to eq(expectedScreenRow.gsub(/\s+/, ''))
      end

    end

    it 'verify facility friendly name in list' do
      button_element = @driver.button(:id => 'back-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_notifications.notification_detail_new_appt_element.wait_until_present(TIME_OUT_LIMIT)
      all_appointments = @landing_appointments.list_of_appointments_elements
      appointment_to_verify = "View details for your appointment," + "\n" + "Date/Time:" + "\n" + "#{@@selectedDay}," + " #{@@setDate2}" + "\n" + "#{@@timeSlot2}" + "\n" + "#{@@selectedDay}, #{@@setDate2} #{@@timeSlot2.gsub("", " ")}" + "\n" + "Details:" + "\n" + "VA Facility Appointment" + "\n" +"#{@friendly_name_boston_details}" + "\n" + "#{@clinic_friendly_name}" + "\n" + "Also called: #{@clinic}" + "\n" + "Prepare/Join:" + "\n" +"Prepare for your appointment"
      expect(@landing_appointments.verifyAppointmentDetailsInList(all_appointments, appointment_to_verify)).to eq(true)
    end

  end

  context 'AC#VAR-10393|TC#VAR-10193 VAR & Utility Integration - Direct Scheduling - New Appointment Form - Location selection' do
    it 'Verify Friendly name for 3 digit location in Select Location' do
      restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name_boston.json", @db)
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("523")
      actual_content = @new_appointment.getScreenContent
      expect(actual_content).to include(@friendly_name_boston)
    end

    it 'Verify Friendly name for 5 digit location in Select Location' do
      @new_appointment.cancelForm
      @common.waitWhileSpinnerPresent
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
      @common.selectAddAppointmentButton("VA")
      restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name_brockton.json", @db)
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      @new_appointment.selectState("523")
      actual_content = @new_appointment.getScreenContent
      expect(actual_content).to include(@friendly_name_brockton)
      @new_appointment.cancelForm
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)

    end


  end

end